# Copyright 1999-2013 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Header: /var/cvsroot/gentoo-x86/sci-misc/pythoncad/pythoncad-1.37-r1.ebuild,v 1.1 2013/06/01 22:28:48 pinkbyte Exp $

EAPI="5"

PYTHON_COMPAT=( python2_{6,7} )
inherit eutils distutils-r1 versionator

MY_PN="PythonCAD"
MY_PV="DS$(get_major_version)-R$(get_after_major_version)"
MY_P="${MY_PN}-${MY_PV}"

DESCRIPTION="CAD program written in PyGTK"
HOMEPAGE="http://sourceforge.net/projects/pythoncad"
SRC_URI="mirror://sourceforge/pythoncad/${MY_P}.tar.gz"

LICENSE="GPL-2"
SLOT="0"
KEYWORDS="~amd64 ~x86"

RDEPEND="dev-python/pygtk:2[${PYTHON_USEDEP}]"
DEPEND=""

S="${WORKDIR}/${MY_P}"

PATCHES=( "${FILESDIR}/${P}-png.patch" )

python_prepare_all() {
	distutils-r1_python_prepare_all
	sed -i \
		-e "s/gtkpycad.png/pythoncad.png/" \
		-e "s/gtkpycad.py/pythoncad/" \
		"${PN}.desktop" || die "sed failed"
}

python_install() {
	distutils-r1_python_install
	python_newscript gtkpycad.py pythoncad
}

src_install() {
	distutils-r1_src_install

	insinto /etc/"${PN}"
	doins prefs.py
	domenu "${PN}".desktop
	newicon gtkpycad.png "${PN}".png
}
