# Copyright 1999-2013 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Header: /var/cvsroot/gentoo-x86/app-crypt/tpm-emulator/tpm-emulator-0.7.4-r1.ebuild,v 1.2 2013/05/10 06:27:54 patrick Exp $

EAPI=2
inherit user linux-mod cmake-utils udev

MY_P=${P/-/_}
DESCRIPTION="Emulator driver for tpm"
HOMEPAGE="https://developer.berlios.de/projects/tpm-emulator"
SRC_URI="mirror://berlios/tpm-emulator/${MY_P}.tar.gz"
LICENSE="GPL-2"

SLOT="0"
KEYWORDS="~amd64 ~x86"

IUSE="ssl modules"
RDEPEND="ssl? ( dev-libs/openssl )"
DEPEND="${RDEPEND}
	!ssl? ( dev-libs/gmp )"

S=${WORKDIR}/${P/-/_}

pkg_setup() {
	enewuser tss -1 -1 /var/lib/tpm tss
	if use modules; then
		CONFIG_CHECK="MODULES"
		linux-mod_pkg_setup
		BUILD_TARGETS="all"
		BUILD_PARAMS="KERNEL_BUILD=${KERNEL_DIR}"
	fi
}

src_prepare() {
	# do not build and install the kernel module
	sed -i 's/COMMAND ${tpmd_dev_BUILD_CMD}//' tpmd_dev/CMakeLists.txt || die
	sed -i 's/install(CODE.*//' tpmd_dev/CMakeLists.txt || die
}

src_configure() {
	mycmakeargs=(
		$(cmake-utils_use_use ssl OPENSSL)
	)
	cmake-utils_src_configure

	# only here we have BUILD_DIR
	MODULE_NAMES="tpmd_dev(misc:${BUILD_DIR}/tpmd_dev/linux)"
}

src_compile() {
	cmake-utils_src_compile
	use modules && linux-mod_src_compile
	emake -C "${BUILD_DIR}/tpmd_dev/linux" tpmd_dev.rules
}

src_install() {
	cmake-utils_src_install
	use modules && linux-mod_src_install

	dodoc README

	udev_newrules "${BUILD_DIR}/tpmd_dev/linux/tpmd_dev.rules" 60-tpmd_dev.rules

	newinitd "${FILESDIR}"/${PN}.initd-0.7.4 ${PN}
	newconfd "${FILESDIR}"/${PN}.confd-0.7.4 ${PN}

	keepdir /var/log/tpm
	fowners tss:tss /var/log/tpm
}
