#!/bin/sh

set -e

MAKEOPTS="-j$(( $(getconf _NPROCESSORS_ONLN) / 3 ))"
NICENESS=15
#export PATH="/usr/lib/ccache/bin${PATH:+:}$PATH"
#export CCACHE_DIR="/var/tmp/ccache"

if [ $# -lt 1 ]; then
	echo "Usage: $(basename $0) arch"
	exit 1
fi

case "$1" in
	"amd64")
		;;
	"arm")
		MAKEOPTS="ARCH=arm CROSS_COMPILE=armv7a-hardfloat-linux-gnueabi- $MAKEOPTS"
		;;
	*)
		echo "Unsupported arch: $1"
		exit 1
		;;
esac

MAKEOPTS="$MAKEOPTS O=$(dirname $(realpath $0))/linux-$1-build"

shift


echo "Running 'make $MAKEOPTS $*' with nice $NICENESS"
nice -n $NICENESS make $MAKEOPTS $*
